package app.firezone.synk.network.Fragments;

import android.app.Dialog;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;

import androidx.appcompat.widget.AppCompatButton;
import androidx.fragment.app.Fragment;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Activities.TransactionHistoryActivity;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.Fragment3Binding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.PaymentModel;
import app.firezone.synk.network.model.TransactionModel;
import app.firezone.synk.network.model.User;
import app.firezone.synk.network.model.UserResponse;
import app.firezone.synk.network.model.WithdrawModel;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;


public class Fragment3 extends Fragment {

    Fragment3Binding binding;

    Dialog dialog;

    AppCompatButton cancelBtn,redeemBtn;
    ImageView trLogo;
    TextView traMethods;

    private MyApi myApi;

    long userId;
    String email, username, phoneno;
    EditText edtAmount,edtNumber;

    DatabaseReference dr;

    long minWithdraw, availWithdraw;
    FirebaseDatabase database;
    FirebaseUser auth;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        binding = Fragment3Binding.inflate(inflater, container, false);
        View root = binding.getRoot();

        myApi = APIClient.getApiClient(getContext()).create(MyApi.class);

        database = FirebaseDatabase.getInstance();
        auth = FirebaseAuth.getInstance().getCurrentUser();

        userId = SharedPrefManager.getInstance(getContext()).getUserId(); // Get userId from SharedPreferences
        if (userId <= 0) {
            Toast.makeText(getContext(), "Invalid user ID", Toast.LENGTH_SHORT).show();
        }
        loadUserData();


        dialog = new Dialog(getContext());
        dialog.setContentView(R.layout.coupon_payment_dialog);

        if (dialog.getWindow() !=null){

            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCancelable(false);
        }

        cancelBtn = dialog.findViewById(R.id.cancelBtn);
        redeemBtn = dialog.findViewById(R.id.redeemAmountBtn);
        edtAmount = dialog.findViewById(R.id.edtAmount);
        edtNumber = dialog.findViewById(R.id.tranNumber);
        trLogo = dialog.findViewById(R.id.trLogo);
        traMethods = dialog.findViewById(R.id.payMethods);



        setMinimumWithdrawal();

        binding.btnHistory.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(getContext(), TransactionHistoryActivity.class));
            }
        });


        binding.gplayBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                trLogo.setImageResource(R.drawable.googleplay);
                traMethods.setText("Google Gift Card");

                dialog.show();
            }
        });

        binding.amzonBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                trLogo.setImageResource(R.drawable.amazon);
                traMethods.setText("Amazon Gift Card");

                dialog.show();
            }
        });


        binding.flipkartBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                trLogo.setImageResource(R.drawable.flipkart_ogo);
                traMethods.setText("Flipkart Gift Card");

                dialog.show();
            }
        });

        if (availWithdraw <= minWithdraw){
            binding.gplayBtn.setBackgroundResource(R.drawable.btn_true);
            binding.amzonBtn.setBackgroundResource(R.drawable.btn_true);
            binding.flipkartBtn.setBackgroundResource(R.drawable.btn_true);
        }else {

            Toast.makeText(getContext(), "Minimum Withdraw "+minWithdraw+ "rs", Toast.LENGTH_SHORT).show();
            binding.gplayBtn.setBackgroundResource(R.drawable.btn_false);
            binding.amzonBtn.setBackgroundResource(R.drawable.btn_false);
            binding.flipkartBtn.setBackgroundResource(R.drawable.btn_false);
        }

        // To Set Progress Limit

        binding.totalCoinmx.setText(String.valueOf(minWithdraw));
        binding.coinMinum.setText(String.valueOf(minWithdraw));
        binding.reqEsewa.setText(String.valueOf(minWithdraw));
        binding.reqKhalti.setText(String.valueOf(minWithdraw));
        binding.reqNtc.setText(String.valueOf(minWithdraw));



        cancelBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dialog.dismiss();
            }
        });

        redeemBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                checkAmount();
            }
        });

        return root;
    }

    private void loadUserData() {

        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
        Call<ApiResponse> call = myApi.fetchProfileData(userId);

        call.enqueue(new Callback<ApiResponse>() {
            @Override
            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    User model = response.body().getUser();

                    binding.totalCoinmx.setText(String.valueOf(model.getWinBalance()));
                    binding.reqEsewa.setText(String.valueOf(model.getWinBalance()));
                    binding.reqKhalti.setText(String.valueOf(model.getWinBalance()));
                    binding.reqNtc.setText(String.valueOf(model.getWinBalance()));


                    email = model.getEmail();
                    username = model.getName();
                    phoneno = model.getPhoneno();
                    availWithdraw = model.getWinBalance();

                    int availwith = (int) model.getWinBalance();

                    binding.progressBarUp.setProgress(availwith);
                    binding.esewaProg.setProgress((int) model.getWinBalance());
                    binding.khaltiProg.setProgress((int) model.getWinBalance());
                    binding.ntcProg.setProgress((int) model.getWinBalance());

                } else {
                    Toast.makeText(getContext(), "Failed to fetch user data", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ApiResponse> call, Throwable throwable) {

            }
        });
    }

    private void checkAmount() {

        if (Integer.parseInt(edtAmount.getText().toString())<=minWithdraw){
            edtAmount.setError("Minimum "+minWithdraw+ " Coin Withdraw");
        }
        else if (Long.parseLong(edtAmount.getText().toString()) >= availWithdraw) {
            Toast.makeText(getContext(), "Not Enough Money", Toast.LENGTH_SHORT).show();
            dialog.dismiss();
        }else {
            String paymentMethods = traMethods.getText().toString();
            updateRedeem(paymentMethods);

        }
    }


    private void updateRedeem(String paymentMethods) {

        String withdCoin = edtAmount.getText().toString();
        String mobNumber = edtNumber.getText().toString();

        Calendar calForDate= Calendar.getInstance();
        SimpleDateFormat currentDate= new SimpleDateFormat("dd-MM-yy");
        String date= currentDate.format(calForDate.getTime());
        String method  =  paymentMethods;

        myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
        Call<WithdrawModel> call = myApi.storeWithdraw(
                String.valueOf(userId),
                withdCoin,
                username,
                email,
                mobNumber,
                date,
                phoneno,
                "N/A",
                "N/A",
                "N/A",
                "N/A",
                "Pending",
                method
        );

        call.enqueue(new Callback<WithdrawModel>() {
            @Override
            public void onResponse(Call<WithdrawModel> call, Response<WithdrawModel> response) {
                if (response.isSuccessful() && response.body() != null) {
                    Toast.makeText(getContext(), "Withdraw request submitted successfully!", Toast.LENGTH_SHORT).show();
                    deductedMoney();
                    dialog.dismiss();
                } else {
                    Toast.makeText(getContext(), "Failed to submit request: " + response.message(), Toast.LENGTH_LONG).show();
                }
            }

            @Override
            public void onFailure(Call<WithdrawModel> call, Throwable t) {
                Toast.makeText(getContext(), "Error: " + t.getMessage(), Toast.LENGTH_LONG).show();
            }
        });

    }


    private void setMinimumWithdrawal() {

        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
        Call<ArrayList<PaymentModel>> call = myApi.fetchPaymentSetting();

        call.enqueue(new Callback<ArrayList<PaymentModel>>() {
            @Override
            public void onResponse(Call<ArrayList<PaymentModel>> call, Response<ArrayList<PaymentModel>> response) {

                if (response.isSuccessful() && response.body() != null && !response.body().isEmpty()) {
                    PaymentModel model = response.body().get(0); // Assuming you need the first payment setting

                    minWithdraw = model.getMinWithdraw();

                    int avail = (int) minWithdraw;

                    binding.esewaProg.setMax(avail);
                    binding.khaltiProg.setMax((int) minWithdraw);
                    binding.ntcProg.setMax((int) minWithdraw);
                    binding.progressBarUp.setMax(avail);
                    binding.coinMinum.setText(String.valueOf(model.getMinWithdraw()));

                } else {
                    Toast.makeText(getContext(), "Failed to fetch payment settings", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ArrayList<PaymentModel>> call, Throwable throwable) {
                Toast.makeText(getContext(), "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }
    private  void deductedMoney(){

        long inputUserCoins = Long.parseLong(edtAmount.getText().toString());

        long finalCoins =  availWithdraw - inputUserCoins;

        Map<String, Object> updateData = new HashMap<>();
        updateData.put("winBalance",finalCoins);

        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);

        // API Call to update the user's wallet balance
        Call<UserResponse> call = myApi.updateUser(userId, updateData);
        call.enqueue(new Callback<UserResponse>() {
            @Override
            public void onResponse(Call<UserResponse> call, Response<UserResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (response.body().isSuccess()) {
                        saveUsersTransactionDetails();
                        Toast.makeText(getContext(), "Amount Debited..", Toast.LENGTH_SHORT).show();
                        loadUserData();
                    } else {
                        Toast.makeText(getContext(), response.body().getMessage(), Toast.LENGTH_SHORT).show();
                    }
                } else {
                    Toast.makeText(getContext(), "Failed to update balance", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<UserResponse> call, Throwable throwable) {
                Toast.makeText(getContext(), "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }


    private void saveUsersTransactionDetails() {

        String inputCoin = edtAmount.getText().toString();
        // Get user details
        long userIdLong = SharedPrefManager.getInstance(getContext()).getUserId();
        String userId = String.valueOf(userIdLong); // Convert to String for API call
        String date = new SimpleDateFormat("dd-MM-yy", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String time = new SimpleDateFormat("HH:mm:ss", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String transactionId = "TRAN" + System.currentTimeMillis();

        // Initialize API Client
        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);

        Call<TransactionModel> call = myApi.storeUserTransaction(
                userId,
                "Withdraw", // type
                email,
                inputCoin, // amount
                date,
                time,
                transactionId,
                "Wallet", // method
                "Pending" // status
        );

        call.enqueue(new Callback<TransactionModel>() {
            @Override
            public void onResponse(Call<TransactionModel> call, Response<TransactionModel> response) {
                if (response.isSuccessful() && response.body() != null) {
                    Toast.makeText(getContext(), "Transaction Recorded Successfully", Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(getContext(), "Failed to Record Transaction: " + response.message(), Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<TransactionModel> call, Throwable throwable) {
                Toast.makeText(getContext(), "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }


}